/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm;

import ibm.nways.jdm.BulletinBoardLayout;
import ibm.nways.jdm.GraphicComponent;
import ibm.nways.jdm.GraphicElement;
import ibm.nways.jdm.HasJmaPopup;
import ibm.nways.jdm.SelectionBox;
import ibm.nways.jdm.common.Disposable;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.PopupMenu;
import java.awt.Rectangle;
import java.awt.ScrollPane;
import java.io.Serializable;

public class GraphicContainer
extends Container
implements GraphicElement {
    protected int zOrder;
    private static Component selectedComponent;
    private static SelectionBox selectionBox;
    public int selectionBorderThickness = 6;

    public GraphicContainer() {
        this.setLayout(new BulletinBoardLayout());
        this.setSize(100, 100);
    }

    public int getZOrder() {
        return this.zOrder;
    }

    public void setZOrder(int n) {
        this.zOrder = n;
        Container container = this.getParent();
        if (container != null && container instanceof GraphicContainer) {
            ((GraphicContainer)container).updatedZOrder(this);
        }
    }

    public void setSelectedComponent(Component component) {
        Container container;
        if (selectedComponent != null) {
            container = selectionBox.getParent();
            selectionBox.setVisible(false);
            container.remove(selectionBox);
            selectedComponent.removeComponentListener(selectionBox);
        }
        selectedComponent = component;
        if (component != null) {
            if (selectionBox == null) {
                selectionBox = new SelectionBox();
            }
            container = component.getParent();
            Container container2 = container.getParent();
            while (container2 != null && !(container2 instanceof ScrollPane)) {
                if (container2 instanceof GraphicContainer) {
                    container = container2;
                }
                container2 = container2.getParent();
            }
            selectionBox.initFor(component, container, this.selectionBorderThickness);
            selectionBox.setVisible(true);
            container.add((Component)selectionBox, 0);
            component.addComponentListener(selectionBox);
            selectionBox.repaint();
        }
    }

    public void updatedZOrder(GraphicElement graphicElement) {
        Component[] componentArray = this.getComponents();
        int n = 0;
        while (n < componentArray.length) {
            if (componentArray[n] == graphicElement) {
                this.remove((Component)((Object)graphicElement));
                this.add(graphicElement);
            }
            ++n;
        }
    }

    public void add(GraphicComponent graphicComponent) {
        this.add((GraphicElement)graphicComponent);
    }

    public void add(GraphicContainer graphicContainer) {
        this.add((GraphicElement)graphicContainer);
    }

    public void add(GraphicElement graphicElement) {
        int n = this.getComponentCount();
        int n2 = graphicElement.getZOrder();
        int n3 = 0;
        while (n3 < n) {
            Component component = this.getComponent(n3);
            if (component instanceof GraphicElement && n2 < ((GraphicElement)((Object)component)).getZOrder()) {
                super.add((Component)((Object)graphicElement), n3);
                return;
            }
            ++n3;
        }
        super.add((Component)((Object)graphicElement), -1);
    }

    public void update(Graphics graphics) {
    }

    public Dimension getPreferredSize() {
        Serializable serializable;
        Rectangle rectangle = new Rectangle();
        int n = this.getComponentCount();
        int n2 = 0;
        while (n2 < n) {
            serializable = this.getComponent(n2);
            if (((Component)serializable).isVisible()) {
                rectangle = rectangle.union(((Component)serializable).getBounds());
            }
            ++n2;
        }
        serializable = new Dimension(rectangle.width, rectangle.height);
        return serializable;
    }

    public Insets getInsets() {
        return new Insets(0, 0, 0, 0);
    }

    private PopupMenu findParentJmaPopup() {
        PopupMenu popupMenu = null;
        Container container = this.getParent();
        while (container != null) {
            if (container instanceof HasJmaPopup) {
                popupMenu = ((HasJmaPopup)((Object)container)).getNewPopupMenu();
                break;
            }
            container = container.getParent();
        }
        return popupMenu;
    }

    public void dispose() {
        Component component;
        Component[] componentArray = this.getComponents();
        int n = 0;
        while (n < componentArray.length) {
            component = componentArray[n];
            if (component instanceof Disposable) {
                ((Disposable)((Object)component)).dispose();
            }
            ++n;
        }
        this.removeAll();
        if (selectedComponent != null && (component = selectionBox.getParent()) == null) {
            selectedComponent = null;
            selectionBox = null;
        }
    }

    public void reallyDispose() {
    }

    static {
        selectionBox = null;
    }
}

